#include <bits/stdc++.h>

using namespace std;

const int maxn=2e5+10;

vector< pair<int,int> > graf[maxn];

void dijkstra(int pocetni,vector<int> &udaljenost,vector<int> &prosli)
{
    priority_queue<pair<int,int>, vector<pair<int,int> >, greater<pair<int,int> > > najblizi;
    najblizi.push(make_pair(0,pocetni)); //dodam pocetni cvor
    udaljenost[pocetni]=0; //uradim mu udaljenost
    while(!najblizi.empty())
    {
        pair<int,int> cvor=najblizi.top(); //uzimam trenutni najblizi
        najblizi.pop();
        if(cvor.first!=udaljenost[cvor.second]) continue; //ako je on vec posecen (udaljenost mu se kasnije poboljsala)
        for(pair<int,int> i:graf[cvor.second])
        {
            if(udaljenost[i.first]>cvor.first+i.second)
            { //ako je bolje da idem preko trenutnog cvora
                udaljenost[i.first]=cvor.first+i.second; //menjam udaljenost
                najblizi.push(make_pair(udaljenost[i.first],i.first)); //dodajem u priority_queue
                prosli[i.first]=cvor.second; //menjam koji je prosli
            }
        }
    }
}

void nadji(int cvor,vector<int> &prosli,vector<int> &put)
{ //rekurzivno trazim put dok ne dodjem do pocetka, dodajem tek na kraju u vector kako ne bi bilo naopacke
    if(cvor==-1) return;
    nadji(prosli[cvor],prosli,put);
    put.push_back(cvor);
}

int main()
{
    int n;
    cin>>n;
    for(int i=0;i<n-1;i++)
    {
        int u,v;
        cin>>u>>v;
        u--;
        v--;
        graf[u].push_back(make_pair(v,1));
        graf[v].push_back(make_pair(u,1));
    }
    int zlatnici[n];
    long long zbir=0;
    for (int i=0;i<n;i++)
    {
        cin>>zlatnici[i];
        zbir=zlatnici[i]+zbir;
    }
    int pocetni,dokle;
    vector<int> udaljenost(maxn,INT_MAX); //udaljenost[i] je duzina najkraceg puta od pocetnog cvora do cvora i
    vector<int> prosli(maxn,-1); //prosli[i] je cvor koji se nalazi odmah pre cvora i u najkracem putu od pocetnog cvora do cvora i
    int portal[n][n];
    for (int i=0;i<n;i++)
    {
        for (int j=i;j<n;j++)
        {
            portal[i][j]=0;
            portal[j][i]=0;
        }
    }
    for (int i=0;i<n;i++)
    {
        vector<int> udaljenost(maxn,INT_MAX);
        vector<int> prosli(maxn,-1);

        dijkstra(i,udaljenost, prosli);
        for (int j=i;j<n;j++)
        {
            portal[i][j]=udaljenost[j];
            portal[j][i]=udaljenost[j];
        }
    }
    long long ukupno=1000000000000000001;
    long long prenos;
    long long maksi[n];
    int banka=0;
    for (int i=0;i<n;i++)
    {
        prenos=0;
        for (int j=0;j<n;j++)
        {
            prenos=prenos+zlatnici[j]*portal[i][j];

        }
        maksi[i]=prenos;
        if (prenos<ukupno)
        {
            ukupno=prenos;
            banka=i;
        }
    }
    cout<<banka+1<<endl;

    int q;
    int pare,ban;
    cin>>q;
    for (int k=0;k<q;k++)
    {
        cin>>pare>>ban;
        ban--;
        for (int i=0;i<n;i++)
        {
            maksi[i]=maksi[i]+pare*portal[i][ban];
        }
        long long mini=maksi[0];
        banka=0;
        for (int i=0;i<n;i++)
        {
            if (mini>maksi[i])
            {
                mini=maksi[i];
                banka=i;
            }
        }
        cout<<banka+1<<endl;
    }

}